local volume = settings.startup.volume.value

function getSounds()
	return
	{
		sound =
		{
		  { filename = "__botbuzz__/sounds/DRONE_HOVER_AND_AWAY.ogg", volume = 0.9 * volume },
		  { filename = "__botbuzz__/sounds/MACHINE_DRONE_FLY_OVER.ogg", volume = 0.6 * volume },
		  { filename = "__botbuzz__/sounds/DRONE_HOVER.ogg", volume = 0.8 * volume },
		},
		--max_sounds_per_type = 8,
		audible_distance_modifier = 1,
		apparent_volume = 2.5,
		--probability = 1 / (1 * 60) -- average pause between the sound is 1 seconds
	}
end

for _,bot in pairs(data.raw["logistic-robot"]) do
	bot.working_sound = getSounds()
end

for _,bot in pairs(data.raw["construction-robot"]) do
	bot.working_sound = getSounds()
end