# Mushroom Cloud
---
## Introduction

The atomic bomb. It delivers a huge amount of fire power and is everyone's favorite wood trimmer. But its appearance in Factorio is kind of unimpressive. Its ring of fire looks cool - for the first five times. In addition, the use of nukes is usually completely silent. And if it weren't for the tree stumps (standing there, quiet as the nuke itself), nobody would notice it's use anyway.

And therefore, nukes need an upgrade! 

## Details

This mod does two things:

- Firstly, it adds a mushroom cloud explosion animation, which was orignially created for the now abandoned Uranium Power mod. 
- Secondly, this mod informs you about every nuclear detonation within 25 thousand tiles/meters by playing a explosion sound. If your are far away from the explosion (imagine targeting a biter nest with a **[M.I.R.V](https://mods.factorio.com/mods/Klonan/MIRV)**), you'll just hear some echos. If a nuclear explosion goes off within a kilometer or less, the sound will be much more intense. And firing a nuke next to you will result in an earsplitting, awe-inspiring detonation sound. (I tried very hard to get the most promising nuke detonation sound from freesound.org - and i think i found it.)

All values (i.e. which sound will be played in dependence of the distance to the detonation) are fully configurable.

If you want to see this mod in action, please check out the [mod spotlight video](https://www.youtube.com/watch?v=WX-LOAdqlEE) created by Xterminator! 

### Now, just grab some nukes and turn up your speakers - and have fun! 

## Compatible mods
This mod's effects are added to nuclear weapons of the following mods:

- **[Nuclear Artillery](https://mods.factorio.com/mod/Nuclear_Artillery)** by morley376
- **[Atomic Artillery](https://mods.factorio.com/mod/AtomicArtillery)** by SirDoombox
- **[Nuclear Landmines](https://mods.factorio.com/mod/Nuclear%20Landmines)** by Raeon
- **[Advanced Atomics](https://mods.factorio.com/mod/Advanced-Atomics)** by madurban & drbert
- **[MadClown01's Thermonuclear Bombs & Nuclear Processing Expansion](https://mods.factorio.com/mod/Clowns-Nuclear)** by MadClown01

## Credits

Nuke explosion animation: 

- Made for the **[Uranium Power](https://mods.factorio.com/mods/Fatmice/UraniumPower)** mod  by *[Fatmice](https://mods.factorio.com/mods/Fatmice)* (MIT-License)

Nuke explosion sounds:

- "nuclear-detonation-close-proximity.ogg": **[Atomic Explosion and Sub Rumble](https://freesound.org/people/GowlerMusic/sounds/265459/)**, orginal by *[GowlerMusic](https://freesound.org/people/GowlerMusic)* (CC-BY 3.0), slightly modified by Arcitos
- "nuclear-detonation-in-vincinity-1.ogg": **[Long tail explosion](https://freesound.org/people/Robinhood76/sounds/270882/)**, original by *[Robinhood76](https://freesound.org/people/Robinhood76)* (CC-BY-NC 3.0), mixed together with another explosion sound by Arcitos (who recognizes the other sound?)
- "nuclear-explosion-distant-boom-1.ogg"; "nuclear-explosion-distant-boom-2.ogg"; "nuclear-explosion-distant-boom-3.ogg"; "nuclear-explosion-far-away.ogg": **[Booms of Innominatus](https://freesound.org/people/Innominatus/sounds/231377)**, original by *[Innominatus](https://freesound.org/people/Innominatus)* (CC-BY-NC 3.0), split into different explosion sounds by Arcitos
- "nuclear-detonation-in-vincinity-2.ogg": **[Distant nuke explosion](https://www.audioblocks.com/stock-audio/distant-nuke-explosion.html)**, source: *[Audioblocks](https://www.audioblocks.com/)*, modified by OwnlyMe


---
## Changelog

1.0.3 (2018-01-23)

- added mod support for advanced atomics 0.1.3 and MadClown01's Thermonuclear Bombs & Nuclear Processing Expansion 0.1.3
- mushroom cloud effects are now dynamically added to specific projectiles

1.0.2 (2018-01-18)

- fixed wrong file path

1.0.1 (2018-01-18)

- added mod support for nuclear artillery 0.0.1, atomic artillery 0.1.4 and nuclear landmines 1.0.0
- fixed distant sounds not playing due to wrong distance calculation
- added another explosion sound, thanks to OwnlyMe!
- lowered default value for maximum distance of radius one and two  

1.0.0 (2018-01-15)

- initial release