require("util")


smallbiterscale = 1
small_biter_tint1 = {r=0.56, g=0.46, b=0.42, a=0.65}
small_biter_tint2 = {r=1, g=0.63, b=0, a=0.4}

smallspitterscale = 0.5
smallspittertint =	{r=0.68, g=0.4, b=0, a=1}

mediumspitterscale = 0.7
mediumspittertint =	{r=0.83, g=0.39, b=0.36, a=0.75}

bigspitterscale = 1
bigspittertint = {r=0.54, g=0.58, b=0.85, a=0.6}

behemothspitterscale = 1.2
behemothspittertint = {r=0.3, g=0.9, b=0.3, a=0.75}

mediumbiterscale = 1.1
medium_biter_tint1 = {r=0.78, g=0.15, b=0.15, a=0.6}
medium_biter_tint2 = {r=0.9, g=0.3, b=0.3, a=0.75}

bigbiterscale = 1.2
big_biter_tint1 = {r=0.34, g=0.68, b=0.90, a=0.6}
big_biter_tint2 = {r=0.31, g=0.61, b=0.95, a=0.85}

behemothbiterscale = 1.3
behemoth_biter_tint1 = {r=0.3, g=0.9, b=0.3, a=0.75}
behemoth_biter_tint2 = {r=0.88, g=0.24, b=0.24, a=0.9}


function spawner_idle_animation(variation, tint)
return
  {
    layers =
    {
      {
        filename = "__zombie_land__/graphics/spawner.png",
        line_length = 1,
        width = 228,
        height = 190,
        frame_count = 1,
        animation_speed = 0.18,
        direction_count = 1,
        run_mode = "forward-then-backward",
        shift = {0.140625 - 0.65, -0.234375},
        y = variation * 181
      },
      {
        filename = "__zombie_land__/graphics/spawner.png",
        flags = { "mask" },
        width = 228,
        height = 190,
        frame_count = 1,
        animation_speed = 0.18,
        run_mode = "forward-then-backward",
        shift = {-0.34375 - 0.65, -0.375},
        line_length = 1,
        tint = tint,
        y = variation * 148
      }
    }
  }
end

function spawner_die_animation(variation, tint)
return
  {
    layers =
    {
      {
        width = 335,
        height = 53,
        frame_count = 4,
        direction_count = 1,
        shift = {-0.015625 - 0.65, -0.28125},
        stripes =
        {
         {
          filename = "__zombie_land__/graphics/spawner-dies.png",
          width_in_frames = 4,
          height_in_frames = 1,
          y = variation * 184
         }
        }
      }
    }
  }
end

function biterrunanimation(scale, tint1, tint2)
	return
	{
		layers=
		{
			{
				width = 128,
				height = 128,
				frame_count = 8,
				direction_count = 8,
				animation_speed = .5,
				shift = {scale * -0.5, scale * -1.0},
				scale = scale,
				stripes =
				{
		 {
					filename = "__zombie_land__/graphics/zombie_run.png",
					width_in_frames = 8,
					height_in_frames = 8,
				 },
				}
			}
		}
	}
end

function biterattackanimation(scale, tint1, tint2)
	return
	{
		layers=
		{
			{
				width = 128,
				height = 128,
				frame_count = 10,
				direction_count = 8,
				shift = {scale * -0.5, scale * -1.0},
				animation_speed = 0.1,
				scale = scale,
				stripes =
				{
				 {
					filename = "__zombie_land__/graphics/zombie_attack.png",
					width_in_frames = 10,
					height_in_frames = 8,
				 }
				 
				}
			}

		}
	}
end

function biterdieanimation(scale, tint1, tint2)
	return
	{
		layers=
		{
			{
				width = 128,
				height = 128,
				frame_count = 8,
				direction_count = 8,
				shift = {scale * -0.621094, scale * -0.62},
				scale = scale,
				stripes =
				{
					{
						filename = "__zombie_land__/graphics/zombie_headshot.png",
						width_in_frames = 8,
						height_in_frames = 8,
					}
					
				}
			}

			
			
		}
	}
end

function bloodtint()
return {r = 0.6, g = 0.1, b = 0.1}
end

function shadowtint()
return {r = 0, g = 0, b = 0}
end

function bloodparticlescale()
  return 1
end

data:extend(
{
	
	{
		type = "particle",
		name = "blood-particle",
		flags = {"not-on-map"},
		movement_modifier_when_on_ground = 0,
		life_time = 180,
		pictures =
		{
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-01.png",
			priority = "extra-high",
			width = 5,
			height = 6,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-02.png",
			priority = "extra-high",
			width = 4,
			height = 3,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-03.png",
			priority = "extra-high",
			width = 4,
			height = 7,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-04.png",
			priority = "extra-high",
			width = 3,
			height = 3,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-05.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-06.png",
			priority = "extra-high",
			width = 7,
			height = 3,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-07.png",
			priority = "extra-high",
			width = 5,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-08.png",
			priority = "extra-high",
			width = 9,
			height = 10,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-09.png",
			priority = "extra-high",
			width = 7,
			height = 4,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-10.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-11.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-12.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			},
			{
				filename = "__base__/graphics/entity/blood-particle/blood-particle-13.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = bloodtint()
			}
		},
	
		shadows =
		{
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-01.png",
			priority = "extra-high",
			width = 5,
			height = 6,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-02.png",
			priority = "extra-high",
			width = 4,
			height = 3,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-03.png",
			priority = "extra-high",
			width = 4,
			height = 7,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-04.png",
			priority = "extra-high",
			width = 3,
			height = 3,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-05.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-06.png",
			priority = "extra-high",
			width = 7,
			height = 3,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-07.png",
			priority = "extra-high",
			width = 5,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-08.png",
			priority = "extra-high",
			width = 9,
			height = 10,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-09.png",
			priority = "extra-high",
			width = 7,
			height = 4,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-10.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-11.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-12.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			},
			{
			filename = "__base__/graphics/entity/blood-particle/blood-particle-13.png",
			priority = "extra-high",
			width = 4,
			height = 5,
			frame_count = 6,
			scale = bloodparticlescale(),
			tint = shadowtint()
			}
		}
	},
	
  {
    type = "particle-source",
    name = "blood-fountain",
    particle = "blood-particle",
    time_to_live = 10,
    time_to_live_deviation = 5,
    time_before_start = 0,
    time_before_start_deviation = 3,
    height = 0.4,
    height_deviation = 0.1,
    vertical_speed = 0.05,
    vertical_speed_deviation = 0.03,
    horizontal_speed = 0.025,
    horizontal_speed_deviation = 0.025
  },
  {
    type = "particle-source",
    name = "blood-fountain-big",
    particle = "blood-particle",
    time_to_live = 30,
    time_to_live_deviation = 5,
    time_before_start = 0,
    time_before_start_deviation = 10,
    height = 0.4,
    height_deviation = 0.1,
    vertical_speed = 0.15,
    vertical_speed_deviation = 0.05,
    horizontal_speed = 0.04,
    horizontal_speed_deviation = 0.04
  },
		
  {
		type = "unit",
		name = "small-biter",
		icon = "__base__/graphics/icons/small-biter.png",
		icon_size = 32,
		flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "not-repairable", "breaths-air"},
		max_health = 30,
		order = "b-b-a",
		subgroup="enemies",
		healing_per_tick = 0.05,
		collision_box = {{-0.2, -0.2}, {0.2, 0.2}},
		selection_box = {{-0.4, -0.7}, {0.7, 0.4}},
		attack_parameters =
		{
			type = "projectile",
			range = 0.5,
			cooldown = 35,
			ammo_category = "melee",
			ammo_type = make_unit_melee_ammo_type(7),
			sound = make_biter_roars(0.4),
			animation = biterattackanimation(smallbiterscale, small_biter_tint1, small_biter_tint2)
		},
		vision_distance = 60,
		movement_speed = 0.000025,
		distance_per_frame = 0.1,
		pollution_to_join_attack = 10,
		distraction_cooldown = 300,
		min_pursue_time = 100000 * 60,
		max_pursue_distance = 100000,
		corpse = "small-biter-corpse",
		dying_explosion = "blood-explosion-small",
		dying_sound =	 {filename = "__zombie_land__/sound/Zombie-Dies-2.wav", volume = 0.5 },
		working_sound =	  { filename = "__zombie_land__/sound/Zombie-Roar-2.wav", volume = 5.0 },
		run_animation = biterrunanimation(smallbiterscale, small_biter_tint1, small_biter_tint2)
	},
	{
		type = "unit",
		name = "medium-biter",
		icon = "__base__/graphics/icons/medium-biter.png",
		icon_size = 32,
		flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
		max_health = 150,
		order="b-b-b",
		subgroup="enemies",
		resistances =
		{
			{
				type = "physical",
				decrease = 8,
				percent = 20
			},
			{
				type = "explosion",
				percent = 20
			},
		},
		healing_per_tick = 0.05,
		collision_box = {{-0.3, -0.3}, {0.3, 0.3}},
		selection_box = {{-0.7, -1.5}, {0.7, 0.3}},
		sticker_box = {{-0.3, -0.5}, {0.3, 0.1}},
		distraction_cooldown = 3000,
		min_pursue_time = 100000 * 60,
		max_pursue_distance = 100000,
		attack_parameters =
		{
			type = "projectile",
			ammo_category = "melee",
			ammo_type = make_unit_melee_ammo_type(15),
			range = 1,
			cooldown = 35,
			sound = make_biter_roars(0.5),
			animation = biterattackanimation(mediumbiterscale, medium_biter_tint1, medium_biter_tint2)
		},
		vision_distance = 60,
		movement_speed = 0.00004625,
		distance_per_frame = 0.15,
		pollution_to_join_attack = 50,
		corpse = "medium-biter-corpse",
		dying_explosion = "blood-explosion-small",
		dying_sound =	 {filename = "__zombie_land__/sound/Zombie-Dies-2.wav", volume = 0.5 },
		working_sound =	  { filename = "__zombie_land__/sound/Zombie-Roar-2.wav", volume = 5.0 },
		run_animation = biterrunanimation(mediumbiterscale, medium_biter_tint1, medium_biter_tint2)
	},

	{
		type = "unit",
		name = "big-biter",
		order="b-b-c",
		icon = "__base__/graphics/icons/big-biter.png",
		icon_size = 32,
		flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
		max_health = 750,
		subgroup="enemies",
		resistances =
		{
			{
				type = "physical",
				decrease = 16,
				percent = 20,
			},
			{
				type = "explosion",
				percent = 20
			}
		},
		spawning_time_modifier = 12,
		healing_per_tick = 0.05,
		collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
		selection_box = {{-0.7, -1.5}, {0.7, 0.3}},
		sticker_box = {{-0.6, -0.8}, {0.6, 0}},
		distraction_cooldown = 3000,
		min_pursue_time = 100000 * 60,
		max_pursue_distance = 100000,
		attack_parameters =
		{
			type = "projectile",
			range = 1.5,
			cooldown = 35,
			ammo_category = "melee",
			ammo_type = make_unit_melee_ammo_type(30),
			sound =	make_biter_roars(0.6),
			animation = biterattackanimation(bigbiterscale, big_biter_tint1, big_biter_tint2)
		},
		vision_distance = 60,
		movement_speed = 0.00000425,
		distance_per_frame = 0.2,
		-- in pu
		pollution_to_join_attack = 100,
		corpse = "big-biter-corpse",
		dying_explosion = "blood-explosion-big",
		dying_sound =	 {filename = "__zombie_land__/sound/Zombie-Dies-2.wav", volume = 0.5 },
		working_sound =	  { filename = "__zombie_land__/sound/Zombie-Roar-2.wav", volume = 5.0 },
		run_animation = biterrunanimation(bigbiterscale, big_biter_tint1, big_biter_tint2)
	},

	{
		type = "unit",
		name = "behemoth-biter",
		order="b-b-d",
		icon = "__base__/graphics/icons/behemoth-biter.png",
		icon_size = 32,
		flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
		max_health = 6000,
		subgroup="enemies",
		resistances =
		{
			{
				type = "physical",
				decrease = 24,
				percent = 20
			},
			{
				type = "explosion",
				decrease = 12,
				percent = 20
			}
		},
		spawning_time_modifier = 24,
		healing_per_tick = 0.5,
		collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
		selection_box = {{-0.7, -1.5}, {0.7, 0.3}},
		sticker_box = {{-0.6, -0.8}, {0.6, 0}},
		distraction_cooldown = 3000,
		min_pursue_time = 100000 * 60,
		max_pursue_distance = 100000,
		attack_parameters =
		{
			type = "projectile",
			range = 1.5,
			cooldown = 50,
			ammo_category = "melee",
			ammo_type = make_unit_melee_ammo_type(90),
			sound =	make_biter_roars(0.8),
			animation = biterattackanimation(behemothbiterscale, behemoth_biter_tint1, behemoth_biter_tint2)
		},
		vision_distance = 60,
		movement_speed = 0.00000000425,
		distance_per_frame = 0.2,
		-- in pu
		pollution_to_join_attack = 2000,
		corpse = "behemoth-biter-corpse",
		dying_explosion = "blood-explosion-big",
		dying_sound =	 {filename = "__zombie_land__/sound/Zombie-Dies-2.wav", volume = 0.5 },
		working_sound =	  { filename = "__zombie_land__/sound/Zombie-Roar-2.wav", volume = 5.0 },
		run_animation = biterrunanimation(behemothbiterscale, behemoth_biter_tint1, behemoth_biter_tint2)
	},
	{
		type = "corpse",
		name = "small-biter-corpse",
		icon = "__zombie_land__/graphics/zombie_corpse.png",
		icon_size = 32,
		selection_box = {{-0.8, -0.8}, {0.8, 0.8}},
		selectable_in_game = false,
		subgroup="corpses",
		order = "c[corpse]-a[biter]-a[small]",
		flags = {"placeable-neutral", "placeable-off-grid", "building-direction-8-way", "not-repairable", "not-on-map"},
		dying_speed = 0.04,
		time_before_removed = 15 * 60 * 60,
		final_render_layer = "corpse",
		animation = biterdieanimation(smallbiterscale, small_biter_tint1, small_biter_tint2)
	},
	{
		type = "corpse",
		name = "medium-biter-corpse",
		icon = "__base__/graphics/icons/medium-biter-corpse.png",
		icon_size = 32,
		selectable_in_game = false,
		selection_box = {{-1, -1}, {1, 1}},
		flags = {"placeable-neutral", "placeable-off-grid", "building-direction-8-way", "not-on-map"},
		subgroup="corpses",
		order = "c[corpse]-a[biter]-b[medium]",
		dying_speed = 0.04,
		time_before_removed = 15 * 60 * 60,
		final_render_layer = "corpse",
		animation = biterdieanimation(mediumbiterscale, medium_biter_tint1, medium_biter_tint2)
	},

	{
		type = "corpse",
		name = "big-biter-corpse",
		icon = "__base__/graphics/icons/big-biter-corpse.png",
		icon_size = 32,
		selectable_in_game = false,
		selection_box = {{-1, -1}, {1, 1}},
		subgroup="corpses",
		order = "c[corpse]-a[biter]-c[big]",
		flags = {"placeable-neutral", "placeable-off-grid", "building-direction-8-way", "not-on-map"},
		dying_speed = 0.04,
		time_before_removed = 15 * 60 * 60,
		final_render_layer = "corpse",
		animation = biterdieanimation(bigbiterscale, big_biter_tint1, big_biter_tint2)
	},

	{
		type = "corpse",
		name = "behemoth-biter-corpse",
		icon = "__base__/graphics/icons/big-biter-corpse.png",
		icon_size = 32,
		selectable_in_game = false,
		selection_box = {{-1, -1}, {1, 1}},
		subgroup="corpses",
		order = "c[corpse]-a[biter]-c[big]",
		flags = {"placeable-neutral", "placeable-off-grid", "building-direction-8-way", "not-on-map"},
		dying_speed = 0.02,
		time_before_removed = 15 * 60 * 60,
		final_render_layer = "corpse",
		animation = biterdieanimation(behemothbiterscale, behemoth_biter_tint1, behemoth_biter_tint2)
	}
}
)


