require("prototypes.transport-belt-pictures")

function bobmods.logistics.belt_speed(level)
  return level * 0.75/32
end

function bobmods.logistics.belt_distance(level)
  return ((level-1) * settings.startup["bobmods-logistics-beltperlevel"].value) + settings.startup["bobmods-logistics-beltstarting"].value
end


function bobmods.logistics.set_belt_speed(type, belt, level)
  if data.raw[type][belt] then
    data.raw[type][belt].speed = bobmods.logistics.belt_speed(level)
  end
end

function bobmods.logistics.set_belt_distance(belt, level)
  if data.raw["underground-belt"][belt] then
    data.raw["underground-belt"][belt].max_distance = bobmods.logistics.belt_distance(level)
  end
end


data.raw["transport-belt"]["transport-belt"].flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-cross-type-while-moving"}
data.raw["transport-belt"]["fast-transport-belt"].flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-cross-type-while-moving"}
data.raw["transport-belt"]["express-transport-belt"].flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-cross-type-while-moving"}


if settings.startup["bobmods-logistics-beltoverhaul"].value == true then

data:extend(
{
  {
    type = "transport-belt",
    name = "basic-transport-belt",
    icon = "__boblogistics__/graphics/icons/black-transport-belt.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-cross-type-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.3, result = "basic-transport-belt"},
    max_health = 140,
    corpse = "small-remnants",
    resistances = 
    {
      {
        type = "fire",
        percent = 50
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/express-transport-belt.ogg",
        volume = 0.4
      },
      max_sounds_per_type = 3
    },
    animation_speed_coefficient = 32,
    animations =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/black-transport-belt.png",
      priority = "extra-high",
      width = 40,
      height = 40,
      frame_count = 16,
      direction_count = 12
    },
    belt_horizontal = black_belt_horizontal,
    belt_vertical = black_belt_vertical,
    ending_top = black_belt_ending_top,
    ending_bottom = black_belt_ending_bottom,
    ending_side = black_belt_ending_side,
    starting_top = black_belt_starting_top,
    starting_bottom = black_belt_starting_bottom,
    starting_side = black_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.5/32,
    connector_frame_sprites = transport_belt_connector_frame_sprites,
    circuit_connector_sprites = transport_belt_circuit_connector_sprites,
    circuit_wire_connection_point = transport_belt_circuit_wire_connection_point,
    circuit_wire_max_distance = transport_belt_circuit_wire_max_distance
  },

  {
    type = "underground-belt",
    name = "basic-underground-belt",
    icon = "__boblogistics__/graphics/icons/black-underground-belt.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-build-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "basic-underground-belt"},
    max_health = 140,
    corpse = "small-remnants",
    underground_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    underground_remove_belts_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines-remove.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.4, -0.15}, {0.4, 0.1}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    distance_to_enter = 0.5,
    animation_speed_coefficient = 32,
    belt_horizontal = black_belt_horizontal,
    belt_vertical = black_belt_vertical,
    ending_top = black_belt_ending_top,
    ending_bottom = black_belt_ending_bottom,
    ending_side = black_belt_ending_side,
    starting_top = black_belt_starting_top,
    starting_bottom = black_belt_starting_bottom,
    starting_side = black_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.5/32,
    max_distance = 3,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/black-underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          y = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-black-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            y = 85,
            scale = 0.5
          }
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/black-underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-black-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            scale = 0.5
          }
        }
      }
    },
  },

  {
    type = "splitter",
    name = "basic-splitter",
    icon = "__boblogistics__/graphics/icons/black-splitter.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "basic-splitter"},
    max_health = 160,
    corpse = "medium-remnants",
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.9, -0.1}, {0.9, 0.1}},
    selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
    animation_speed_coefficient = 32,
    structure_animation_speed_coefficient = 1.2,
    structure_animation_movement_cooldown = 10,
    belt_horizontal = black_belt_horizontal,
    belt_vertical = black_belt_vertical,
    ending_top = black_belt_ending_top,
    ending_bottom = black_belt_ending_bottom,
    ending_side = black_belt_ending_side,
    starting_top = black_belt_starting_top,
    starting_bottom = black_belt_starting_bottom,
    starting_side = black_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.5/32,
    structure =
    {
      north =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/black-splitter-north.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 83,
        height = 36,
        shift = {0.265625, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-black-splitter-north.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 164,
          height = 70,
          shift = {0.25, 0.046875},
          scale = 0.5
        }
      },
      east =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/black-splitter-east.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 51,
        height = 80,
        shift = {0.109375, -0.03125},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-black-splitter-east.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 93,
          height = 157,
          shift = {0.148438, -0.179688},
          scale = 0.5
        }
      },
      south =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/black-splitter-south.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 85,
        height = 35,
        shift = {0.140625, -0.015625},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-black-splitter-south.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 168,
          height = 67,
          shift = {0.140625, 0.0234375},
          scale = 0.5
        }
      },
      west =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/black-splitter-west.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 51,
        height = 78,
        shift = {0.296875, -0.03125},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-black-splitter-west.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 94,
          height = 154,
          shift = {0.203125, -0.109375},
          scale = 0.5
        }
      },
    },
  },
}
)

end

data:extend(
{
  {
    type = "transport-belt",
    name = "turbo-transport-belt",
    icon = "__boblogistics__/graphics/icons/purple-transport-belt.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-cross-type-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.3, result = "turbo-transport-belt"},
    max_health = 180,
    corpse = "small-remnants",
    resistances = 
    {
      {
        type = "fire",
        percent = 50
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/express-transport-belt.ogg",
        volume = 0.4
      },
      max_sounds_per_type = 3
    },
    animation_speed_coefficient = 32,
    animations =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/purple-transport-belt.png",
      priority = "extra-high",
      width = 40,
      height = 40,
      frame_count = 32,
      direction_count = 12
    },
    belt_horizontal = purple_belt_horizontal,
    belt_vertical = purple_belt_vertical,
    ending_top = purple_belt_ending_top,
    ending_bottom = purple_belt_ending_bottom,
    ending_side = purple_belt_ending_side,
    starting_top = purple_belt_starting_top,
    starting_bottom = purple_belt_starting_bottom,
    starting_side = purple_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.125,
    connector_frame_sprites = transport_belt_connector_frame_sprites,
    circuit_connector_sprites = transport_belt_circuit_connector_sprites,
    circuit_wire_connection_point = transport_belt_circuit_wire_connection_point,
    circuit_wire_max_distance = transport_belt_circuit_wire_max_distance
  },

  {
    type = "underground-belt",
    name = "turbo-underground-belt",
    icon = "__boblogistics__/graphics/icons/purple-transport-belt-to-ground.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-build-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "turbo-underground-belt"},
    max_health = 180,
    corpse = "small-remnants",
    underground_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    underground_remove_belts_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines-remove.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.4, -0.15}, {0.4, 0.1}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    distance_to_enter = 0.5,
    animation_speed_coefficient = 32,
    belt_horizontal = purple_belt_horizontal,
    belt_vertical = purple_belt_vertical,
    ending_top = purple_belt_ending_top,
    ending_bottom = purple_belt_ending_bottom,
    ending_side = purple_belt_ending_side,
    starting_top = purple_belt_starting_top,
    starting_bottom = purple_belt_starting_bottom,
    starting_side = purple_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.125,
    max_distance = 20,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/purple-transport-belt-to-ground-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          y = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-purple-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            y = 85,
            scale = 0.5
          }
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/purple-transport-belt-to-ground-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-purple-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            scale = 0.5
          }
        }
      }
    },
  },

  {
    type = "splitter",
    name = "turbo-splitter",
    icon = "__boblogistics__/graphics/icons/purple-splitter.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "turbo-splitter"},
    max_health = 200,
    corpse = "medium-remnants",
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.9, -0.1}, {0.9, 0.1}},
    selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
    animation_speed_coefficient = 32,
    structure_animation_speed_coefficient = 1.2,
    structure_animation_movement_cooldown = 10,
    belt_horizontal = purple_belt_horizontal,
    belt_vertical = purple_belt_vertical,
    ending_top = purple_belt_ending_top,
    ending_bottom = purple_belt_ending_bottom,
    ending_side = purple_belt_ending_side,
    starting_top = purple_belt_starting_top,
    starting_bottom = purple_belt_starting_bottom,
    starting_side = purple_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.125,
    structure =
    {
      north =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/purple-splitter-north.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 80,
        height = 35,
        shift = {0.225, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-purple-splitter-north.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 164,
          height = 70,
          shift = {0.25, 0.046875},
          scale = 0.5
        }
      },
      east =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/purple-splitter-east.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 46,
        height = 81,
        shift = {0.075, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-purple-splitter-east.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 93,
          height = 157,
          shift = {0.148438, -0.179688},
          scale = 0.5
        }
      },
      south =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/purple-splitter-south.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 82,
        height = 36,
        shift = {0.075, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-purple-splitter-south.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 168,
          height = 67,
          shift = {0.140625, 0.0234375},
          scale = 0.5
        }
      },
      west =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/purple-splitter-west.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 47,
        height = 79,
        shift = {0.25, 0.05},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-purple-splitter-west.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 94,
          height = 154,
          shift = {0.203125, -0.109375},
          scale = 0.5
        }
      },
    },
  },
}
)


data:extend(
{
  {
    type = "transport-belt",
    name = "ultimate-transport-belt",
    icon = "__boblogistics__/graphics/icons/green-transport-belt.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-cross-type-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.3, result = "ultimate-transport-belt"},
    max_health = 190,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 50
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/express-transport-belt.ogg",
        volume = 0.4
      },
      max_sounds_per_type = 3
    },
    animation_speed_coefficient = 32,
    animations =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
      priority = "extra-high",
      width = 40,
      height = 40,
      frame_count = 32,
      direction_count = 12
    },
    belt_horizontal = green_belt_horizontal,
    belt_vertical = green_belt_vertical,
    ending_top = green_belt_ending_top,
    ending_bottom = green_belt_ending_bottom,
    ending_side = green_belt_ending_side,
    starting_top = green_belt_starting_top,
    starting_bottom = green_belt_starting_bottom,
    starting_side = green_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.15625,
    connector_frame_sprites = transport_belt_connector_frame_sprites,
    circuit_connector_sprites = transport_belt_circuit_connector_sprites,
    circuit_wire_connection_point = transport_belt_circuit_wire_connection_point,
    circuit_wire_max_distance = transport_belt_circuit_wire_max_distance
  },

  {
    type = "underground-belt",
    name = "ultimate-underground-belt",
    icon = "__boblogistics__/graphics/icons/green-transport-belt-to-ground.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-build-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "ultimate-underground-belt"},
    max_health = 190,
    corpse = "small-remnants",
    underground_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    underground_remove_belts_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines-remove.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.4, -0.15}, {0.4, 0.1}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    distance_to_enter = 0.5,
    animation_speed_coefficient = 32,
    belt_horizontal = green_belt_horizontal,
    belt_vertical = green_belt_vertical,
    ending_top = green_belt_ending_top,
    ending_bottom = green_belt_ending_bottom,
    ending_side = green_belt_ending_side,
    starting_top = green_belt_starting_top,
    starting_bottom = green_belt_starting_bottom,
    starting_side = green_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.15625,
    max_distance = 25,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt-to-ground-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          y = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            y = 85,
            scale = 0.5
          }
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt-to-ground-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            scale = 0.5
          }
        }
      },
    },
  },

  {
    type = "splitter",
    name = "ultimate-splitter",
    icon = "__boblogistics__/graphics/icons/green-splitter.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "ultimate-splitter"},
    max_health = 210,
    corpse = "medium-remnants",
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.9, -0.1}, {0.9, 0.1}},
    selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
    animation_speed_coefficient = 32,
    structure_animation_speed_coefficient = 1.2,
    structure_animation_movement_cooldown = 10,
    belt_horizontal = green_belt_horizontal,
    belt_vertical = green_belt_vertical,
    ending_top = green_belt_ending_top,
    ending_bottom = green_belt_ending_bottom,
    ending_side = green_belt_ending_side,
    starting_top = green_belt_starting_top,
    starting_bottom = green_belt_starting_bottom,
    starting_side = green_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.15625,
    structure =
    {
      north =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-north.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 80,
        height = 35,
        shift = {0.225, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-north.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 164,
          height = 70,
          shift = {0.265625, 0},
          scale = 0.5
        }
      },
      east =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-east.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 46,
        height = 81,
        shift = {0.075, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-east.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 93,
          height = 157,
          shift = {0.148438, -0.179688},
          scale = 0.5
        }
      },
      south =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-south.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 82,
        height = 36,
        shift = {0.075, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-south.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 168,
          height = 67,
          shift = {0.140625, 0.0234375},
          scale = 0.5
        }
      },
      west =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-west.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 47,
        height = 79,
        shift = {0.25, 0.05},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-west.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 94,
          height = 154,
          shift = {0.203125, -0.109375},
          scale = 0.5
        }
      },
    },
  },
}
)


if settings.startup["bobmods-logistics-beltoverhaul"].value == true and settings.startup["bobmods-logistics-beltoverhaulspeed"].value == true then
  bobmods.logistics.set_belt_speed("splitter", "basic-splitter", 1)
  bobmods.logistics.set_belt_speed("transport-belt", "basic-transport-belt", 1)
  bobmods.logistics.set_belt_speed("underground-belt", "basic-underground-belt", 1)

  bobmods.logistics.set_belt_speed("splitter", "splitter", 2)
  bobmods.logistics.set_belt_speed("transport-belt", "transport-belt", 2)
  bobmods.logistics.set_belt_speed("underground-belt", "underground-belt", 2)

  bobmods.logistics.set_belt_speed("splitter", "fast-splitter", 3)
  bobmods.logistics.set_belt_speed("transport-belt", "fast-transport-belt", 3)
  bobmods.logistics.set_belt_speed("underground-belt", "fast-underground-belt", 3)

  bobmods.logistics.set_belt_speed("splitter", "express-splitter", 4)
  bobmods.logistics.set_belt_speed("transport-belt", "express-transport-belt", 4)
  bobmods.logistics.set_belt_speed("underground-belt", "express-underground-belt", 4)

  bobmods.logistics.set_belt_speed("splitter", "turbo-splitter", 5)
  bobmods.logistics.set_belt_speed("transport-belt", "turbo-transport-belt", 5)
  bobmods.logistics.set_belt_speed("underground-belt", "turbo-underground-belt", 5)

  bobmods.logistics.set_belt_speed("splitter", "ultimate-splitter", 6)
  bobmods.logistics.set_belt_speed("transport-belt", "ultimate-transport-belt", 6)
  bobmods.logistics.set_belt_speed("underground-belt", "ultimate-underground-belt", 6)
end


if settings.startup["bobmods-logistics-ugdistanceoverhaul"].value == true then
  if settings.startup["bobmods-logistics-beltoverhaul"].value == true then
    bobmods.logistics.set_belt_distance("basic-underground-belt", 1)
    bobmods.logistics.set_belt_distance("underground-belt", 2)
    bobmods.logistics.set_belt_distance("fast-underground-belt", 3)
    bobmods.logistics.set_belt_distance("express-underground-belt", 4)
    bobmods.logistics.set_belt_distance("turbo-underground-belt", 5)
    bobmods.logistics.set_belt_distance("ultimate-underground-belt", 6)
  else
    bobmods.logistics.set_belt_distance("underground-belt", 1)
    bobmods.logistics.set_belt_distance("fast-underground-belt", 2)
    bobmods.logistics.set_belt_distance("express-underground-belt", 3)
    bobmods.logistics.set_belt_distance("turbo-underground-belt", 4)
    bobmods.logistics.set_belt_distance("ultimate-underground-belt", 5)
  end
else
  data.raw["underground-belt"]["underground-belt"].max_distance = 5
  data.raw["underground-belt"]["fast-underground-belt"].max_distance = 10
  data.raw["underground-belt"]["express-underground-belt"].max_distance = 15
end


