--For 0.13.13 and later there will be layer-10 through layer-15 that can be used.
local projectile_layer = "layer-13"
local suffix = "-blockable"

local function make_projectile_blockable (prototype_name)
  local prototype = data.raw.projectile[prototype_name]
  if not prototype then
    return prototype_name
  end
  local newname = prototype.name .. "-blockable"
  -- if it already exists don't duplicate
  if not data.raw.projectile[newname] then
    local proto = table.deepcopy(prototype)
    proto.name = proto.name .. suffix
    if proto.collision_box then
      -- expand if all 0s
      proto.collision_box = {
        {
          math.min(-0.1, proto.collision_box[1][1]),
          math.min(-0.5, proto.collision_box[1][2]),
        }, {
          math.max(0.1, proto.collision_box[1][1]),
          math.max(0.5, proto.collision_box[1][2]),
        }
      }
    else
      proto.collision_box = {
        {
          -0.1,
          -0.5
        }, {
          0.1,
          0.5
        }
      }
    end
    if proto.collision_mask then
      table.insert(proto.collision_mask, projectile_layer)
    else
      proto.collision_mask = {projectile_layer}
    end
    data:extend({proto})
  end
  return newname
end

local function compressRange(prototype)
  if prototype.attack_parameters then
    if prototype.attack_parameters.range then
      prototype.attack_parameters.range = 22 + (prototype.attack_parameters.range - 22) * 0.75
    end
    if prototype.attack_parameters.range and prototype.attack_parameters.prepare_range then
      prototype.attack_parameters.prepare_range = prototype.attack_parameters.range + 5
    end
    if prototype.attack_parameters.range and prototype.attack_parameters.prepare_range then
      prototype.attack_parameters.prepare_range = prototype.attack_parameters.range + 5
    end
  end
end

-- biters
for _, unit in pairs(data.raw.unit) do
  if string.find(unit.name, "biter", 1, true) then
    if unit.distance_per_frame then unit.distance_per_frame = unit.distance_per_frame + 0.1 end
    if unit.movement_speed then unit.movement_speed = unit.movement_speed + 0.1 end
    if unit.max_health and unit.max_health > 0 then unit.max_health = math.ceil(unit.max_health * 1.25) end
    if unit.attack_parameters
        and unit.attack_parameters.ammo_type
        and unit.attack_parameters.ammo_type.action
        and unit.attack_parameters.ammo_type.action.action_delivery
        and unit.attack_parameters.ammo_type.action.action_delivery.target_effects
        and unit.attack_parameters.ammo_type.action.action_delivery.target_effects.damage then
      unit.attack_parameters.ammo_type.action.action_delivery.target_effects.damage.amount = unit.attack_parameters.ammo_type.action.action_delivery.target_effects.damage.amount * 1.25
    end
  elseif string.find(unit.name, "spitter", 1, true) then

    compressRange(unit)
    if unit.distance_per_frame then unit.distance_per_frame = unit.distance_per_frame + 0.1 end
    if unit.movement_speed then unit.movement_speed = unit.movement_speed + 0.1 end
    if unit.max_health and unit.max_health > 0 then unit.max_health = math.ceil(unit.max_health * 1.25) end
    if unit.attack_parameters then
      unit.attack_parameters.min_attack_distance = nil
      if unit.attack_parameters.cooldown then
        unit.attack_parameters.cooldown = unit.attack_parameters.cooldown * 0.75
      end
      if unit.attack_parameters.warmup then
        unit.attack_parameters.warmup = unit.attack_parameters.warmup * 0.5
      end
      unit.attack_parameters.range = unit.attack_parameters.range * 1.05
      if unit.attack_parameters.ammo_type
          and unit.attack_parameters.ammo_type.action
          and unit.attack_parameters.ammo_type.action.action_delivery
          and unit.attack_parameters.ammo_type.action.action_delivery.projectile then
        unit.attack_parameters.ammo_type.action.action_delivery.projectile = make_projectile_blockable(unit.attack_parameters.ammo_type.action.action_delivery.projectile)
      end
    end

  end
end

-- worms
for _, turret in pairs(data.raw.turret) do
  compressRange(turret)
  if string.find(turret.name, "worm", 1, true) then
    if turret.max_health and turret.max_health > 0 then turret.max_health = math.ceil(turret.max_health * 1.25) end
    if turret.attack_parameters and turret.attack_parameters.range then
      turret.attack_parameters.range = turret.attack_parameters.range * 1.1
      turret.attack_parameters.prepare_range = turret.attack_parameters.range + 5
    end
  else
    if turret.max_health and turret.max_health > 4 then turret.max_health = math.ceil(turret.max_health * 0.75) end
  end
end

for _, turret in pairs(data.raw["ammo-turret"]) do
  compressRange(turret)
  if turret.max_health and turret.max_health > 4 then turret.max_health = math.ceil(turret.max_health * 0.75) end
end

for _, turret in pairs(data.raw["fluid-turret"]) do
  compressRange(turret)
  if turret.max_health and turret.max_health > 4 then turret.max_health = math.ceil(turret.max_health * 0.75) end
end

for _, turret in pairs(data.raw["electric-turret"]) do
  compressRange(turret)
  if turret.max_health and turret.max_health > 4 then turret.max_health = math.ceil(turret.max_health * 0.75) end
end

-- spawners
for _, spawner in pairs(data.raw["unit-spawner"]) do
  if spawner.max_health then spawner.max_health = spawner.max_health + 500 end
end

-- walls
for _, wall in pairs(data.raw.wall) do
  wall.collision_mask = {"item-layer", "object-layer", "player-layer", "water-tile", projectile_layer}
end
