DEBUG = false

function printf(p,s, ...)
    if not DEBUG then
        return
    end

    local args = table.pack(...)
    for i = 1, args.n do
        if type(args[i]) == 'table' then
            args[i] = dump(args[i])
        end
    end
	local player = game.players[p]
	if player ~= nil then
		player.force.print(string.format(s, table.unpack(args, 1, args.n)))
	else
		log( string.format(s, table.unpack(args, 1, args.n)) )
	end
end

function force_debug( msg )
	for _, player in pairs(game.players) do
		player.print( msg )
	end
end

function string.starts(String,Start)
   return string.sub(String,1,string.len(Start))==Start
end

-- /c game.player.teleport({-1143,-66}, "nauvis")

script.on_init(
	function()
		printf(0, "Nicefill INIT.")
		if game.active_mods["FARL"] then
			remote.call("farl", "add_entity_to_trigger", "grass-1")
		end

	end
)

function tmpsurface_set( tmpsurface, x, y, value )
	if tmpsurface == nil then tmpsurface = {} end
	if tmpsurface[x] == nil then tmpsurface[x] = {} end
	tmpsurface[x][y] = value
end

function tmpsurface_get( tmpsurface, x, y )
	if tmpsurface[x] == nil then return nil end
	if tmpsurface[x][y] == nil then return nil end
	return tmpsurface[x][y]
end

function do_nicefill( game, event )
	if event.player_index == nil then
		event.player_index = 1
	end
	
	--log( serpent.block( event ) )
	--log( serpent.block( event.robot.surface.name ) )
	
	evtsurface = game.surfaces[event.surface_index];
	evtsurfacename = evtsurface.name;
	nicename = "NiceFill_" .. evtsurfacename;
	
	player = game.players[ event.player_index ]
	printf(event.player_index, "Nicefill on_player_built_tile event : " .. serpent.dump( event ) )
	printf(event.player_index, "Nicefill on_player_built_tile item : " .. serpent.dump( event.item.name ) )
	printf(event.player_index, "Nicefill on_player_built_tile pos : " .. serpent.dump( type(event.positions) ) )
	
	
	--log( serpent.block( event.item ) )
	--log( serpent.block( evtsurface ) )
	--log( serpent.block( evtsurfacename ) )
	--log( serpent.block( nicename ) )
	
	if event.item.name == 'landfill' then
		if DEBUG then log( "NiceFill on landfill" ) end
		
		--delete NiceFill surface, we are no longer using it
		if game.surfaces["NiceFill"] ~= nil then
			game.delete_surface("NiceFill")
		end
		
		if game.surfaces[nicename] ~= nil and event.tiles ~= nil and event.tiles[1] ~= nil then
			
			if not game.surfaces[nicename].is_chunk_generated( {x=(event.tiles[1].position.x/32),y=(event.tiles[1].position.y/32)} ) then
				game.surfaces[nicename].request_to_generate_chunks( {x=event.tiles[1].position.x,y=event.tiles[1].position.y}, 0 )
			end
			
			game.surfaces[nicename].force_generate_chunk_requests()
			
			if DEBUG then log(serpent.block( game.surfaces[nicename].get_tile( event.tiles[1].position ).name )) end
			
			if string.match(game.surfaces[nicename].get_tile( event.tiles[1].position ).name, "water") ~= nil then
				-- fix incorrect surface
				log( "NiceFill surface regenerate" )
				game.delete_surface( nicename )
			end
		end
		
		if game.surfaces[nicename] == nil
		then
			printf( event.player_index, serpent.dump( game.surfaces ) )
			if DEBUG then log( serpent.dump( game.surfaces ) ) end
			-- make a copy of the world, without water.
			
			local map_gen_settings = evtsurface.map_gen_settings
			
			--map_gen_settings.autoplace_controls = nil
			--map_gen_settings.autoplace_controls = {}
			
			for k,v in pairs(map_gen_settings.autoplace_controls) do
				if DEBUG then log( serpent.block( k ) ) end
				if DEBUG then log( serpent.block( v ) ) end
			end
			
			map_gen_settings.autoplace_controls["enemy-base"] = {frequency="none",size="none",richness="none"}
			map_gen_settings.autoplace_controls["trees"] = {frequency="none",size="none",richness="none"}
			-- map_gen_settings.default_enable_all_autoplace_controls = false
			map_gen_settings.autoplace_settings =
			{
				entity =
				{
					treat_missing_as_default = false,
					settings =
					{
						frequency = "none",
						size = "none",
						richness = "none"
					}
				},
				decorative =
				{
					treat_missing_as_default = false,
					settings =
					{
						frequency = "none",
						size = "none",
						richness="none"
					}
				}
			}
			
			printf( event.player_index, serpent.block( map_gen_settings.cliff_settings ) )
			printf( event.player_index, serpent.block( map_gen_settings.autoplace_settings ) )
			if DEBUG then
				log( serpent.block( map_gen_settings.cliff_settings ) )
				log( serpent.block( map_gen_settings.autoplace_settings ) )
			end
			
			map_gen_settings.water = "none"
			map_gen_settings.starting_area = "none"
			map_gen_settings.peaceful_mode = true
			
			map_gen_settings.cliff_settings = {
				cliff_elevation_0 = 0,
				cliff_elevation_interval = 0,
				name = "cliff"
			}
			
			-- if not pcall(game.create_surface( "NiceFill", map_gen_settings )) then
				-- log( "Failed to create surface " .. serpent.block( map_gen_settings ) )
			-- end
			
			if pcall( game.create_surface,nicename, map_gen_settings ) then
				if DEBUG then log( "NiceFill surface success." ) end
			else
				log( "NiceFill surface fail." )
				force_debug( "NiceFill failed create surface. Did you disable or enable any mods mid-game ?" );
			end
				
			
			NiceFillSurface = game.surfaces[nicename]
			
			--player.force.print( serpent.block( map_gen_settings ) )
			if DEBUG then log( serpent.block( evtsurface.map_gen_settings ) ) end
			if DEBUG then log( serpent.block( game.surfaces[nicename].map_gen_settings ) ) end
		else
			NiceFillSurface = game.surfaces[nicename]
		end
		
		local tilelist = {}				--this list is temporary, it contains tiles that has been landfilled, and we remove ready tiles from it each round.
		
		--build teporary list of landfilled tiles
		for k,vv in pairs(event.tiles) do
			local v = vv.position -- quick fix for 0.16.17
			local lc = 0;
			
			if not NiceFillSurface.is_chunk_generated( {x=(v.x/32),y=(v.y/32)} ) then
				NiceFillSurface.request_to_generate_chunks( {x=v.x,y=v.y}, 0 )
			end
			
			NiceFillSurface.force_generate_chunk_requests()
			
			local NFSTile = NiceFillSurface.get_tile( {x=v.x,y=v.y} )
			
			table.insert( tilelist, {name=NFSTile.name, position = NFSTile.position } )
		end
		--and update the game map. There is probably a way to cache this too, TODO?
		evtsurface.set_tiles( tilelist );
		
		if settings.global["nicefill-dowaterblending"].value == true then
			local waterblend_tilelist = {}
		
			for k,vv in pairs(event.tiles) do
				local v = vv.position
				
				--log( serpent.block ( evtsurface.get_tile({x=v.x-1,y=v.y}).name ) )
				for i = -2,2 do
					for j = -2,2 do
						tmppos = {x=(v.x+j),y=(v.y+i)}
						if evtsurface.get_tile(tmppos).name == "deepwater" then
							table.insert( waterblend_tilelist, {name="water", position = tmppos } )
						end
					end
				end
			end
			
			evtsurface.set_tiles( waterblend_tilelist );
		end
		
	end
end

script.on_event(defines.events.on_robot_built_tile,
	function(event)
		if DEBUG then log( serpent.block( event ) ) end
		if DEBUG then log( serpent.block( event.robot ) ) end
		
		local sfcindex={}
		for k,v in pairs(game.surfaces) do
		   sfcindex[v.name]=k
		end
		
		event.surface_index = sfcindex[event.robot.surface.name]
		
		if not pcall(do_nicefill, game, event ) then
			log( "NiceFill failed." )
			force_debug( "NiceFill failed." );
		end
		
		--log( serpent.block( sfcindex[event.robot.surface.name] ) )
		--do_nicefill( game, event )
		
	end
)

script.on_event(defines.events.on_player_built_tile,
	function(event)
		if DEBUG then log( "NiceFill on_player_built_tile" ) end
		if DEBUG then log( serpent.block(event) ) end
		
		local sfcindex={}
		for k,v in pairs(game.surfaces) do
		   sfcindex[v.name]=k
		end
		
		event.surface_index = sfcindex[game.players[event.player_index].surface.name]
		
		if not pcall(do_nicefill, game, event ) then
			log( "NiceFill failed." )
			force_debug( "NiceFill failed." );
		end
		
		--log( serpent.block( sfcindex[game.players[event.player_index].surface.name] ) )
		--do_nicefill( game, event )
	end
)

script.on_event(defines.events.on_chunk_generated,
	function(event)
		if string.starts(event.surface.name, "NiceFill") then
			printf( 1, serpent.block( event.area ) )
		end
	end
)

remote.add_interface("NiceFill", {
	scan_and_fix = function()
		game.players[1].force.print( "Test remote call" )
	end
})
