data:extend(
{
  {
    type = "technology",
    name = "fluid-generator-1",
    prerequisites =
    {
      "oil-processing",
      "electric-engine",
    },
    icon = "__bobpower__/graphics/icons/fluid-generator-128.png",
    icon_size = 128,
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "fluid-generator"
      },
    },
    unit =
    {
      count = 150,
      ingredients =
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1}
      },
      time = 30
    },
    upgrade = true,
    order = "[fluid-generator]-1",
  },

  {
    type = "technology",
    name = "fluid-generator-2",
    prerequisites =
    {
      "fluid-generator-1",
    },
    icon = "__bobpower__/graphics/icons/fluid-generator-128.png",
    icon_size = 128,
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "fluid-generator-2"
      },
    },
    unit =
    {
      count = 200,
      ingredients =
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1},
        {"science-pack-3", 1}
      },
      time = 30
    },
    upgrade = true,
    order = "[fluid-generator]-2",
  },

  {
    type = "technology",
    name = "fluid-generator-3",
    prerequisites =
    {
      "fluid-generator-2",
    },
    icon = "__bobpower__/graphics/icons/fluid-generator-128.png",
    icon_size = 128,
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "fluid-generator-3"
      },
    },
    unit =
    {
      count = 250,
      ingredients =
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1},
        {"science-pack-3", 1},
        {"production-science-pack", 1}
      },
      time = 30
    },
    upgrade = true,
    order = "[fluid-generator]-3",
  },
}
)



if mods["bobrevamp"] and data.raw.fluid.hydrogen and data.raw.fluid.oxygen and data.raw.fluid.nitrogen then
data:extend(
{
  {
    type = "technology",
    name = "hydrazine-generator",
    prerequisites =
    {
      "fluid-generator-3",
      "hydrazine",
      "advanced-electronics-2",
    },
    icon = "__bobpower__/graphics/icons/fluid-generator-128.png",
    icon_size = 128,
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "hydrazine-generator"
      },
    },
    unit =
    {
      count = 350,
      ingredients =
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1},
        {"science-pack-3", 1},
        {"production-science-pack", 1},
        {"high-tech-science-pack", 1},
      },
      time = 30
    },
    upgrade = true,
    order = "[hydrazine-generator]",
  },
}
)
end
