local event = require 'utils.event'

--local main_caption = " --Junkyard-- "
--local sub_caption = "Some may call this junk. Me, I call them treasures."
local info = [[
	Citizen Log #468-2A-3287, Freelancer Cole
	
	To whoever is reading this message,
	i have most likely already left this doomed place,	or... well..
	
	I am stranded on this foreign world since months and i have given up on fixing my ships transceiver.
	Things aren't looking too good, i must admit.	
	The rust and devastation tells a story of an advanced civilization,
	which seems to have evacuated their home long time ago.
	
	Any natural resources are rare and the ones worth while are too hard for me to reach.
	Luckily, the wrecks yield all kinds of useful scraps, but also various dangers.
	Almost lost half a leg some days ago while digging out a crate.
	
	The wildlife is extremely aggressive, especially at the time of night.	
	Most of these insect appearing like creatures seem to live underground.
	Stay near your light sources, if you want to have a chance of surviving here!!
	
	I must make a move now, hopefully will find those missing parts.
	
	###Log End###
]]

local function create_map_intro_button(player)
	if player.gui.left["map_intro_button"] then return end
	local b = player.gui.top.add({type = "sprite-button", caption = "?", name = "map_intro_button", tooltip = "Map Info"})
	b.style.font_color = {r = 0.8, g = 0.8, b = 0.8}
	b.style.font = "heading-1"
	b.style.minimal_height = 38
	b.style.minimal_width = 38
	b.style.top_padding = 2
	b.style.left_padding = 4
	b.style.right_padding = 4
	b.style.bottom_padding = 2
end

local function create_map_intro(player)
	if player.gui.left["map_intro_frame"] then player.gui.left["map_intro_frame"].destroy() end
	local frame = player.gui.left.add {type = "frame", name = "map_intro_frame", direction = "vertical"}
	
	local t = frame.add {type = "table", column_count = 1}	
	
	local b = frame.add {type = "button", caption = "Close", name = "close_map_intro_frame", align = "right"}	
	b.style.font = "default"
	b.style.minimal_height = 30
	b.style.minimal_width = 30
	b.style.top_padding = 2
	b.style.left_padding = 4
	b.style.right_padding = 4
	b.style.bottom_padding = 2
	
	local frame = t.add {type = "frame"}
	local l = frame.add {type = "label", caption = info}
	l.style.single_line = false
	l.style.font = "heading-3"
	l.style.font_color = {r=0.95, g=0.95, b=0.95}			
end

local function on_player_joined_game(event)	
	local player = game.players[event.player_index]
	create_map_intro_button(player)
	if player.online_time == 0 then
		create_map_intro(player)
	end
end

local function on_gui_click(event)
	if not event then return end
	if not event.element then return end
	if not event.element.valid then return end	
	local player = game.players[event.element.player_index]
	if event.element.name == "close_map_intro_frame" then player.gui.left["map_intro_frame"].destroy() return end	
	if event.element.name == "map_intro_button" then
		if player.gui.left["map_intro_frame"] then
			player.gui.left["map_intro_frame"].destroy()
		else
			create_map_intro(player)
		end		
		return
	end	
end

event.add(defines.events.on_player_joined_game, on_player_joined_game)
event.add(defines.events.on_gui_click, on_gui_click)