require "modules.backpack_research"
require "modules.biters_double_damage"
require "modules.biters_avoid_damage"
--require "modules.biters_yield_coins"
--require "modules.dynamic_landfill"
--require "modules.dynamic_player_spawn"
require "modules.explosive_biters"
require "modules.satellite_score"
require "modules.spawners_contain_biters"
--require "modules.spitters_spit_biters"
require "modules.splice_double"


local event = require 'utils.event'
local math_random = math.random

local function on_player_joined_game(event)
	local player = game.players[event.player_index]
	if not global.new_player_equipped then global.new_player_equipped = {} end
	
	if not global.new_player_equipped[player.name] then
		player.insert({name = "raw-fish", count = 3})
		player.insert({name = "iron-plate", count = 64})
		--player.insert({name = "iron-gear-wheel", count = 64})
		--player.insert({name = "copper-plate", count = 128})
		--player.insert({name = "copper-cable", count = 64})
		player.insert({name = "pistol", count = 1})
		player.insert({name = "firearm-magazine", count = 64})
		--player.insert({name = "shotgun", count = 1})
		--player.insert({name = "shotgun-shell", count = 16})
		--player.insert({name = "light-armor", count = 1})
		global.new_player_equipped[player.name] = true
		
		local radius = 320
		game.forces.player.chart(game.surfaces[1], {{x = -1 * radius, y = -1 * radius}, {x = radius, y = radius}})	
	end
end

local function on_player_created(event)	
	local player = game.players[event.player_index]			
	
end
local function on_tick(event)	
	if game.tick % 3600 ~= 1 then return end
	if math_random(1,8) ~= 1 then return end
	
	local surface = event.surface
	
	local spawners = surface.find_entities_filtered({force = "enemy", type = "unit-spawner"})
	if not spawners[1] then return end
	
	local target = surface.find_nearest_enemy({position = spawners[math_random(1, #spawners)].position, max_distance=1500, force="enemy"})
	if not target then return end
	
	surface.set_multi_command({
		command={
				type=defines.command.attack_area,
				destination=target.position,
				radius=16,
				distraction=defines.distraction.by_anything
			},
		unit_count = math_random(6,12),
		force = "enemy",
		unit_search_distance=1024
	})	
end



local function on_research_finished(event)
	
end

event.add(defines.events.on_tick, on_tick)
event.add(defines.events.on_research_finished, on_research_finished)
event.add(defines.events.on_player_joined_game, on_player_joined_game)
event.add(defines.events.on_player_created, on_player_created)
--event.add(defines.events.on_chunk_generated, on_chunk_generated)